<h2>Sales History</h2>
<div class="sales-history">
<table class="pos-table">

<!-- ================= FILTER BAR ================= -->
<form method="get" action="/pos/sales" class="sales-filter">

    <input type="date" name="from" value="<?= htmlspecialchars($_GET['from'] ?? '') ?>">
    <input type="date" name="to" value="<?= htmlspecialchars($_GET['to'] ?? '') ?>">

    <input type="text"
           name="search"
           placeholder="Search receipt #, customer, payment..."
           value="<?= htmlspecialchars($_GET['search'] ?? '') ?>">

    <button type="submit">Filter</button>

</form>

<br>

<!-- ================= SALES TABLE ================= -->
<table class="sales-table">
    <thead>
        <tr>
            <th>#</th>
            <th>Date</th>
            <th>Customer</th>
            <th>Payment</th>
            <th>Total</th>
            <th></th>
        </tr>
    </thead>
    <tbody>

    <?php if (empty($sales)): ?>
        <tr>
            <td colspan="6" style="text-align:center;">No sales found</td>
        </tr>
    <?php else: ?>
        <?php foreach ($sales as $sale): ?>
            <tr>
                <td><?= (int)$sale['id'] ?></td>
                <td><?= htmlspecialchars($sale['created_at']) ?></td>
                <td><?= htmlspecialchars($sale['customer_name'] ?? 'Walk-in') ?></td>
                <td><?= htmlspecialchars($sale['payment_method']) ?></td>
                <td>RM <?= number_format($sale['total'], 2) ?></td>
                <td>
                    <a href="/pos/receipt?sale_id=<?= (int)$sale['id'] ?>">View</a>
                </td>
            </tr>
        <?php endforeach; ?>
    <?php endif; ?>

    </tbody>
</table>
