<?php
// receipt.php

if (!isset($sale) || !isset($items)) {
    die('Invalid receipt data');
}

// Safe defaults (prevents 500 errors)
$paymentMethod = $sale['payment_method'] ?? 'cash';
$tendered      = isset($sale['tendered']) ? (float)$sale['tendered'] : 0;
$changeAmount  = isset($sale['change_amount']) ? (float)$sale['change_amount'] : 0;
?>

<div class="receipt-container">

    <div class="receipt-header">
        <h2>Sales Receipt</h2>
        <div>Date: <?= htmlspecialchars($sale['created_at']) ?></div>
        <div>Receipt #: <?= (int)$sale['id'] ?></div>
    </div>

    <hr>

    <!-- ================= CUSTOMER ================= -->
    <?php if (!empty($sale['customer_name'])): ?>
        <div style="margin-bottom:10px;">
            <strong>Customer:</strong><br>
            <?= htmlspecialchars($sale['customer_name']) ?><br>
            <?php if (!empty($sale['customer_phone'])): ?>
                <small><?= htmlspecialchars($sale['customer_phone']) ?></small>
            <?php endif; ?>
        </div>
        <hr>
    <?php endif; ?>

    <!-- ================= ITEMS ================= -->
    <table class="receipt-table">
        <thead>
            <tr>
                <th style="text-align:left;">Item</th>
                <th>Qty</th>
                <th>Price</th>
                <th style="text-align:right;">Total</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($items as $item): ?>
                <tr>
                    <td><?= htmlspecialchars($item['name']) ?></td>
                    <td><?= (int)$item['quantity'] ?></td>
                    <td>RM <?= number_format($item['price'], 2) ?></td>
                    <td style="text-align:right;">
                        RM <?= number_format($item['price'] * $item['quantity'], 2) ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <hr>

    <!-- ================= SUMMARY ================= -->
    <div class="receipt-summary">

        <div class="line">
            <span>Payment Method:</span>
            <strong><?= ucfirst(htmlspecialchars($paymentMethod)) ?></strong>
        </div>

        <div class="line">
            <span>Total:</span>
            <strong>RM <?= number_format($sale['total'], 2) ?></strong>
        </div>

        <?php if ($paymentMethod === 'cash' && $tendered > 0): ?>
            <div class="line">
                <span>Tendered:</span>
                <strong>RM <?= number_format($tendered, 2) ?></strong>
            </div>

            <?php if ($changeAmount > 0): ?>
                <div class="line">
                    <span>Change:</span>
                    <strong>RM <?= number_format($changeAmount, 2) ?></strong>
                </div>
            <?php endif; ?>
        <?php endif; ?>

    </div>

    <hr>

    <!-- ================= ACTIONS ================= -->
    <div class="receipt-actions">
        <button onclick="window.print()">Print</button>
        <a href="/pos" class="new-sale-btn">New Sale</a>
    </div>

</div>

<style>
.receipt-container {
    max-width: 600px;
    margin: 30px auto;
    background: #fff;
    padding: 20px;
    border-radius: 8px;
    font-family: Arial, sans-serif;
}

.receipt-header {
    text-align: center;
}

.receipt-table {
    width: 100%;
    border-collapse: collapse;
}

.receipt-table th,
.receipt-table td {
    padding: 6px;
    font-size: 14px;
}

.receipt-table thead {
    border-bottom: 1px solid #ccc;
}

.receipt-summary {
    margin-top: 10px;
}

.receipt-summary .line {
    display: flex;
    justify-content: space-between;
    padding: 4px 0;
}

.receipt-actions {
    margin-top: 20px;
    text-align: center;
}

.receipt-actions button,
.receipt-actions .new-sale-btn {
    padding: 8px 15px;
    margin: 5px;
    background: #3498db;
    color: #fff;
    border: none;
    text-decoration: none;
    cursor: pointer;
    border-radius: 4px;
}

@media print {
    .receipt-actions {
        display: none;
    }
}
</style>
