<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

session_start();

if (file_exists(__DIR__ . '/installed.lock')) {
    die('Installer locked. Delete install/installed.lock to reinstall.');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $cfg = [
        'host' => $_POST['db_host'],
        'name' => $_POST['db_name'],
        'user' => $_POST['db_user'],
        'pass' => $_POST['db_pass'],
    ];

    try {
        $pdo = new PDO(
            'mysql:host=' . $cfg['host'] . ';dbname=' . $cfg['name'],
            $cfg['user'],
            $cfg['pass'],
            [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
        );

        $schema = file_get_contents(__DIR__ . '/schema.sql');
        $pdo->exec($schema);

        file_put_contents(__DIR__ . '/installed.lock', date('c'));

        file_put_contents(
            __DIR__ . '/../config/database.php',
            '<?php return ' . var_export($cfg, true) . ';'
        );

        echo 'Installation complete. <a href="/">Go to app</a>';
        exit;

    } catch (Exception $e) {
        $error = $e->getMessage();
    }
}
?>
<h2>Repair CRM Installer</h2>
<?php if (!empty($error)) echo '<pre>' . htmlspecialchars($error) . '</pre>'; ?>
<form method="post">
DB Host: <input name="db_host" required><br>
DB Name: <input name="db_name" required><br>
DB User: <input name="db_user" required><br>
DB Pass: <input name="db_pass"><br><br>
<button type="submit">Install</button>
</form>
