<?php

namespace App\WorkOrders\Controllers;

use App\Core\Database;
use App\Core\Auth;


class WorkOrderController extends \App\Core\BaseController

{
public function index()
{
    $this->requireLogin();
$this->requirePermission('work_orders_access');


    $branchId = $_SESSION['branch_id'];

    $orders = Database::fetchAll(
        "SELECT 
            w.*,
            c.name AS customer_name
         FROM work_orders w
         LEFT JOIN customers c ON c.id = w.customer_id
         WHERE w.branch_id = ?
         ORDER BY w.id DESC",
        [$branchId]
    );

$this->render('work_orders/index', compact('orders'));

}


    public function create()
    {
        $this->requireLogin();
$this->requirePermission('work_orders_access');


        $customers = Database::fetchAll(
            "SELECT id, name, phone
             FROM customers
             ORDER BY name ASC"
        );

$this->render('work_orders/create', compact('customers'));
    }

    public function store()
    {
        $this->requireLogin();
$this->requirePermission('work_orders_access');


        $branchId = $_SESSION['branch_id'];

        $customerName  = trim($_POST['customer_name'] ?? '');
        $customerPhone = trim($_POST['customer_phone'] ?? '');
        $brand  = trim($_POST['brand'] ?? '');
        $model  = trim($_POST['model'] ?? '');
        $serial = trim($_POST['serial'] ?? '');
        $problem = trim($_POST['problem'] ?? '');

        if ($customerName === '' || $brand === '' || $model === '' || $problem === '') {
            die('Missing required fields');
        }

        Database::begin();

        try {
            /* -------------------------
               1. CUSTOMER (GLOBAL)
            ------------------------- */
            Database::execute(
                "INSERT INTO customers (name, phone, created_at)
                 VALUES (?, ?, NOW())",
                [$customerName, $customerPhone]
            );
            $customerId = Database::lastInsertId();

            /* -------------------------
               2. DEVICE (GLOBAL)
            ------------------------- */
            Database::execute(
                "INSERT INTO devices (customer_id, brand, model, serial)
                 VALUES (?, ?, ?, ?)",
                [$customerId, $brand, $model, $serial]
            );
            $deviceId = Database::lastInsertId();

            /* -------------------------
               3. WORK ORDER (BRANCH)
            ------------------------- */
            Database::execute(
                "INSERT INTO work_orders (
                    customer_id,
                    device_id,
                    problem,
                    status,
                    branch_id,
                    created_at
                 ) VALUES (?, ?, ?, ?, ?, NOW())",
                [$customerId, $deviceId, $problem, 'open', $branchId]
            );

            Database::commit();
        } catch (\Throwable $e) {
            Database::rollback();
            die('Failed to create work order');
        }

        header('Location: /work-orders');
        exit;
    }

    public function view()
    {
        $this->requireLogin();
$this->requirePermission('work_orders_access');


        $id = (int)($_GET['id'] ?? 0);
        $branchId = $_SESSION['branch_id'];

        $order = Database::fetchOne(
            "SELECT 
                w.*,
                c.name AS customer_name,
                c.phone AS customer_phone
             FROM work_orders w
             LEFT JOIN customers c ON c.id = w.customer_id
             WHERE w.id = ? AND w.branch_id = ?",
            [$id, $branchId]
        );

        if (!$order) {
            die('Work order not found');
        }

$this->render('work_orders/view', compact('order'));
    }

    public function update()
    {
        $this->requireLogin();
$this->requirePermission('work_orders_access');


        $branchId = $_SESSION['branch_id'];

        Database::execute(
            "UPDATE work_orders
             SET status = ?
             WHERE id = ? AND branch_id = ?",
            [$_POST['status'], $_POST['id'], $branchId]
        );

        header('Location: /work-orders/view?id=' . (int)$_POST['id']);
        exit;
    }

    public function print()
    {
        $this->requireLogin();
$this->requirePermission('work_orders_access');


        $id = (int)($_GET['id'] ?? 0);
        $branchId = $_SESSION['branch_id'];

        $order = Database::fetchOne(
            "SELECT 
                w.*,
                c.name,
                c.phone
             FROM work_orders w
             LEFT JOIN customers c ON c.id = w.customer_id
             WHERE w.id = ? AND w.branch_id = ?",
            [$id, $branchId]
        );

        if (!$order) {
            die('Work order not found');
        }

$this->render('work_orders/print', compact('order'));
        
    }
    
}
