<?php
namespace App\POS;

class PosCart
{
    public static function get()
    {
        if (!isset($_SESSION['pos_cart'])) {
            $_SESSION['pos_cart'] = [
                'items' => [],
                'total' => 0
            ];
        }
        return $_SESSION['pos_cart'];
    }

    public static function add(array $product)
    {
        $id = $product['id'];
        if (!isset($_SESSION['pos_cart']['items'][$id])) {
            $_SESSION['pos_cart']['items'][$id] = [
                'id' => $id,
                'name' => $product['name'],
                'price' => $product['price'],
                'qty' => 0
            ];
        }

        $_SESSION['pos_cart']['items'][$id]['qty']++;
        $_SESSION['pos_cart']['total'] += $product['price'];
    }

    public static function clear()
    {
        unset($_SESSION['pos_cart']);
    }
}
