<?php
namespace App\Inventory;

use App\Core\Database;

class InventoryService
{
    public function deduct($productId, $branchId, $qty)
    {
        $row = Database::fetchOne(
            "SELECT quantity FROM inventory_stock WHERE product_id = ? AND branch_id = ?",
            [$productId, $branchId]
        );

        if (!$row || $row['quantity'] < $qty) {
            throw new \Exception('Insufficient stock');
        }

        Database::execute(
            "UPDATE inventory_stock SET quantity = quantity - ? WHERE product_id = ? AND branch_id = ?",
            [$qty, $productId, $branchId]
        );
    }

    public function lowStock()
    {
        return Database::fetchAll(
            "SELECT * FROM inventory_stock WHERE quantity <= min_quantity"
        );
    }

    public function transfer($productId, $from, $to, $qty)
    {
        $this->deduct($productId, $from, $qty);

        Database::execute(
            "UPDATE inventory_stock SET quantity = quantity + ?
             WHERE product_id = ? AND branch_id = ?",
            [$qty, $productId, $to]
        );

        Database::execute(
            "INSERT INTO inventory_transfers (product_id, from_branch, to_branch, quantity, created_at)
             VALUES (?, ?, ?, ?, NOW())",
            [$productId, $from, $to, $qty]
        );
    }
}
