<?php
namespace App\Inventory\Controllers;

use App\Core\Database;
use App\Core\Auth;

class InventoryManageController extends \App\Core\BaseController
{
    public function index()
    {
        $this->requireLogin();
$this->requirePermission('inventory_access');



        $branchId = $_SESSION['branch_id'];

        $products = Database::fetchAll(
            "SELECT 
                p.*,
                COALESCE(ps.quantity, 0) AS quantity
             FROM products p
             LEFT JOIN product_stocks ps
               ON ps.product_id = p.id
              AND ps.branch_id = ?
             ORDER BY p.id DESC",
            [$branchId]
        );

        require __DIR__ . '/../../../resources/views/inventory/index.php';
    }

    public function create()
    {
        $this->requireLogin();
$this->requirePermission('inventory_access');



        require __DIR__ . '/../../../resources/views/inventory/create.php';
    }

    public function store()
    {
        $this->requireLogin();
$this->requirePermission('inventory_access');



        $branchId = $_SESSION['branch_id'];

        Database::begin();

        try {

            /* ===============================
               1️⃣ CREATE GLOBAL PRODUCT
            =============================== */
            Database::execute(
                "INSERT INTO products (name, sku, barcode, sale_price)
                 VALUES (?, ?, ?, ?)",
                [
                    $_POST['name'],
                    $_POST['sku'],
                    $_POST['barcode'],
                    (float)$_POST['sale_price']
                ]
            );

            $productId = Database::lastInsertId();

            /* ===============================
               2️⃣ INITIALIZE BRANCH STOCK
            =============================== */
            Database::execute(
                "INSERT INTO product_stocks (product_id, branch_id, quantity)
                 VALUES (?, ?, ?)",
                [
                    $productId,
                    $branchId,
                    (int)$_POST['quantity']
                ]
            );

            Database::commit();

        } catch (\Throwable $e) {

            Database::rollback();
            die('Failed to create product');
        }

        /* =========================================================
           🔥 IMPORTANT: RETURN TO POS IF REQUESTED
        ========================================================== */
$return = $_POST['return'] ?? null;

if ($return === 'pos') {
    header('Location: /pos?add_product_id=' . $productId);
    exit;
}


        /* ===============================
           DEFAULT REDIRECT
        =============================== */
        header('Location: /inventory');
        exit;
    }

    public function edit()
    {
        $this->requireLogin();
$this->requirePermission('inventory_access');



        $id = (int)($_GET['id'] ?? 0);
        $branchId = $_SESSION['branch_id'];

        $product = Database::fetchOne(
            "SELECT 
                p.*,
                COALESCE(ps.quantity, 0) AS quantity
             FROM products p
             LEFT JOIN product_stocks ps
               ON ps.product_id = p.id
              AND ps.branch_id = ?
             WHERE p.id = ?",
            [$branchId, $id]
        );

        if (!$product) {
            die('Product not found');
        }

        require __DIR__ . '/../../../resources/views/inventory/edit.php';
    }

    public function update()
    {
        $this->requireLogin();
$this->requirePermission('inventory_access');



        $branchId = $_SESSION['branch_id'];
        $productId = (int)$_POST['id'];

        Database::begin();

        try {

            /* ===============================
               UPDATE GLOBAL PRODUCT
            =============================== */
            Database::execute(
                "UPDATE products
                 SET name = ?, sku = ?, barcode = ?, sale_price = ?
                 WHERE id = ?",
                [
                    $_POST['name'],
                    $_POST['sku'],
                    $_POST['barcode'],
                    (float)$_POST['sale_price'],
                    $productId
                ]
            );

            /* ===============================
               UPDATE BRANCH STOCK
            =============================== */
            Database::execute(
                "INSERT INTO product_stocks (product_id, branch_id, quantity)
                 VALUES (?, ?, ?)
                 ON DUPLICATE KEY UPDATE quantity = VALUES(quantity)",
                [
                    $productId,
                    $branchId,
                    (int)$_POST['quantity']
                ]
            );

            Database::commit();

        } catch (\Throwable $e) {

            Database::rollback();
            die('Failed to update product');
        }

        header('Location: /inventory');
        exit;
    }

    public function delete()
    {
        $this->requireLogin();
$this->requirePermission('inventory_access');



        $id = (int)($_GET['id'] ?? 0);

        Database::execute(
            "DELETE FROM products WHERE id = ?",
            [$id]
        );

        header('Location: /inventory');
        exit;
    }
}
