<?php
namespace App\Employees\Controllers;

use App\Core\Database;
use App\Core\Auth;

class EmployeeController
{
    public function loginForm()
    {
        require __DIR__ . '/../../../resources/views/employees/login.php';
    }

public function login()
{
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';

    $emp = Database::fetchOne(
        "SELECT * FROM employees WHERE email = ?",
        [$email]
    );

    if (!$emp || !password_verify($password, $emp['password'])) {
        header('Location: /login');
        exit;
    }

    Auth::login($emp);

    // 🔴 THIS LINE IS MANDATORY
    $_SESSION['branch_id'] = (int)$emp['branch_id'];

    header('Location: /pos');
    exit;
}


    public function logout()
    {
        Auth::logout();
        header('Location: /login');
        exit;
    }
}
