<?php
namespace App\Customers\Controllers;

use App\Core\Database;
use App\Core\Auth;
use App\Core\Permission;

class CustomerController extends \App\Core\BaseController

{
    public function index()
    {
        $this->requireLogin();
$this->requirePermission('customers_access');

        $customers = Database::fetchAll(
            "SELECT * FROM customers ORDER BY created_at DESC"
        );

        require __DIR__ . '/../../../resources/views/customers/index.php';
    }

    public function view()
    {
        $this->requireLogin();
$this->requirePermission('customers_access');

        $id = (int)($_GET['id'] ?? 0);
        $branchId = $_SESSION['branch_id'];

        $customer = Database::fetchOne(
            "SELECT * FROM customers WHERE id = ?",
            [$id]
        );

        if (!$customer) {
            die('Customer not found');
        }

        $orders = Database::fetchAll(
            "SELECT 
                w.*,
                d.brand,
                d.model,
                w.branch_id,
                CASE WHEN w.branch_id = ? THEN 1 ELSE 0 END AS can_edit
             FROM work_orders w
             JOIN devices d ON d.id = w.device_id
             WHERE w.customer_id = ?
             ORDER BY w.id DESC",
            [$branchId, $id]
        );

        require __DIR__ . '/../../../resources/views/customers/view.php';
    }

    /* ================= AJAX SEARCH (POS) ================= */
public function ajaxSearch()
{
    if (!Auth::check()) {
        http_response_code(401);
        echo json_encode([]);
        exit;
    }

    header('Content-Type: application/json');

    $q = trim($_GET['q'] ?? '');

    if (strlen($q) < 2) {
        echo json_encode([]);
        exit;
    }

    $customers = Database::fetchAll(
        "SELECT id, name, phone
         FROM customers
         WHERE name LIKE ? OR phone LIKE ?
         ORDER BY name ASC
         LIMIT 10",
        ["%$q%", "%$q%"]
    );

    echo json_encode($customers);
    exit;
}


    /* ================= ADD CUSTOMER (POS INLINE) ================= */
    public function addAjax()
    {
        if (!Auth::check()) {
            http_response_code(401);
            exit;
        }

        header('Content-Type: application/json');

        $data = json_decode(file_get_contents('php://input'), true);
        $name  = trim($data['name'] ?? '');
        $phone = trim($data['phone'] ?? '');

        if ($name === '') {
            echo json_encode(['ok' => false]);
            exit;
        }

        Database::execute(
            "INSERT INTO customers (name, phone, created_at)
             VALUES (?, ?, NOW())",
            [$name, $phone]
        );

        $id = Database::lastInsertId();

        echo json_encode([
            'ok'   => true,
            'id'   => $id,
            'name' => $name,
            'phone'=> $phone
        ]);
        exit;
    }
}
