<?php
namespace App\Core;

use App\Core\Database;

class Tenant
{
    private static $enabled = false;

    public static function enable()
    {
        self::$enabled = true;
    }

    public static function disable()
    {
        self::$enabled = false;
    }

    public static function isEnabled()
    {
        return self::$enabled;
    }

public static function current()
{

    return $_SESSION['tenant_id'] ?? null;

    // Do NOT reuse tenant_id blindly
    unset($_SESSION['tenant_id']);

    $host = $_SERVER['HTTP_HOST'] ?? '';
    $host = explode(':', $host)[0]; // strip port

    $parts = explode('.', $host);
    $subdomain = count($parts) > 2 ? $parts[0] : 'repair';

    $row = Database::fetchOne(
        "SELECT id FROM tenants WHERE subdomain = ? AND status = 'active'",
        [$subdomain],
        false
    );

    if (!$row) {
        // HARD FAIL is better than cross-tenant leak
        die('Tenant not found');
    }

    $_SESSION['tenant_id'] = (int)$row['id'];
    return (int)$row['id'];
}
}
