<?php
namespace App\Core;

class Permission
{
    public static function allow(string $permissionKey): bool
    {
        if (!Auth::check()) {
            return false;
        }

        $user = Auth::user();
        $roleId = $user['role_id'] ?? null;

        if (!$roleId) {
            return false;
        }

        // NOTE:
        // permissions table uses column `code` (NOT `key`)
        $row = Database::fetchOne(
            "SELECT 1
             FROM role_permissions rp
             JOIN permissions p ON p.id = rp.permission_id
             WHERE rp.role_id = ? AND p.code = ?",
            [$roleId, $permissionKey],
            false
        );

        return (bool)$row;
    }
}
