<?php
namespace App\Core;

use App\Core\Database;

class Migrator
{
    public static function currentVersion()
    {
        $row = Database::fetchOne(
            "SELECT version FROM schema_versions ORDER BY id DESC LIMIT 1"
        );
        return $row ? $row['version'] : '0.0.0';
    }

    public static function apply($version, callable $up)
    {
        Database::execute("START TRANSACTION");

        try {
            $up();

            Database::execute(
                "INSERT INTO schema_versions (version, applied_at)
                 VALUES (?, NOW())",
                [$version]
            );

            Database::execute("COMMIT");
        } catch (\Exception $e) {
            Database::execute("ROLLBACK");
            throw $e;
        }
    }
}
