<?php
namespace App\Core;

abstract class BaseController
{
    protected function requireLogin(): void
    {
        if (!Auth::check()) {
            header('Location: /login');
            exit;
        }
    }

    protected function requirePermission(string $permission): void
    {
        if (!Auth::hasPermission($permission)) {
            http_response_code(403);
            require __DIR__ . '/../../resources/views/errors/403.php';
            exit;
        }
    }

    protected function render(string $view, array $data = []): void
    {
        extract($data);

        ob_start();
        require __DIR__ . '/../../resources/views/' . $view . '.php';
        $content = ob_get_clean();

        require __DIR__ . '/../../resources/views/layouts/layout.php';
    }
}
