<?php
namespace App\Core;

class Auth
{
    public static function check(): bool
    {
        return isset($_SESSION['employee']) && is_array($_SESSION['employee']);
    }

    public static function user(): ?array
    {
        return self::check() ? $_SESSION['employee'] : null;
    }

public static function login(array $employee): void
{
    session_regenerate_id(true);

    // ✅ Store full employee record into session
    $_SESSION['employee'] = $employee;

    // ✅ Force cast super admin flag safely
    $_SESSION['employee']['is_super_admin'] =
        (bool)($employee['is_super_admin'] ?? false);

    // Set branch
    if (!isset($_SESSION['branch_id'])) {
        $_SESSION['branch_id'] = $employee['branch_id'] ?? 1;
    }

    // Load permissions
    self::loadPermissions($employee['role_id'] ?? null);

    if (isset($employee['id'])) {
        Database::execute(
            "UPDATE employees SET last_login = NOW() WHERE id = ?",
            [$employee['id']]
        );
    }
}


    public static function logout(): void
    {
        $_SESSION = [];
        if (session_id() !== '') {
            session_destroy();
        }
    }

    /* =======================================================
       🔥 ENTERPRISE PERMISSION SYSTEM
    ======================================================= */

    private static function loadPermissions(?int $roleId): void
    {
        if (!$roleId) {
            $_SESSION['permissions'] = [];
            return;
        }

        $rows = Database::fetchAll(
            "SELECT p.code
             FROM role_permissions rp
             JOIN permissions p ON p.id = rp.permission_id
             WHERE rp.role_id = ?",
            [$roleId]
        );

        $_SESSION['permissions'] = array_column($rows, 'code');
    }

public static function hasPermission(string $code): bool
{
    if (!self::check()) {
        return false;
    }

    $employee = $_SESSION['employee'];

    // 🔥 SUPER ADMIN BYPASS (clean + safe)
    if (!empty($employee['is_super_admin'])) {
        return true;
    }

    $permissions = $_SESSION['permissions'] ?? [];

    return in_array($code, $permissions, true);
}

}
