<?php
namespace App\Core;

use App\Core\Database;
use App\Core\Auth;

class Audit
{
    public static function log($action, $entity, $entityId = null, $data = null)
    {
        $user = Auth::user();

        Database::execute(
            "INSERT INTO audit_logs (employee_id, action, entity, entity_id, data, created_at)
             VALUES (?, ?, ?, ?, ?, NOW())",
            [
                $user ? $user['id'] : null,
                $action,
                $entity,
                $entityId,
                $data ? json_encode($data) : null
            ]
        );
    }
}
