<?php

define('BASE_PATH', dirname(__DIR__, 2));

// ============================================
// SESSION BOOTSTRAP (CPANEL SAFE)
// ============================================

// Force a writable session path
$sessionPath = __DIR__ . '/../../storage/sessions';
if (!is_dir($sessionPath)) {
    mkdir($sessionPath, 0777, true);
}

ini_set('session.save_path', $sessionPath);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_httponly', 1);

if (session_status() === PHP_SESSION_NONE) {
    session_start();
    
}

// --------------------------------------------
// Autoloader
// --------------------------------------------
spl_autoload_register(function ($class) {
    $prefix = 'App\\';
    if (strncmp($prefix, $class, strlen($prefix)) !== 0) {
        return;
    }

    $relative = substr($class, strlen($prefix));
    $file = __DIR__ . '/../' . str_replace('\\', '/', $relative) . '.php';

    if (file_exists($file)) {
        require $file;
    }
});
