<?php
namespace App\Audit\Controllers;

use App\Core\BaseController;
use App\Core\Database;

class AuditController extends BaseController
{
    public function index()
    {
        $this->requireLogin();
        $this->requirePermission('reports_access'); 
        // Or create new permission: audit_access (recommended later)

        $branchId = $_SESSION['branch_id'];

        $logs = Database::fetchAll(
            "SELECT 
                a.id,
                a.action,
                a.entity,
                a.entity_id,
                a.created_at,
                e.name AS employee_name
             FROM audit_logs a
             LEFT JOIN employees e 
                ON e.id = a.employee_id
             WHERE a.branch_id = ?
             ORDER BY a.id DESC",
            [$branchId]
        );

        $this->render('audit/index', [
            'logs' => $logs
        ]);
    }
}
