<?php
namespace App\Admin\Controllers;

use App\Core\BaseController;
use App\Core\Database;

class RoleController extends BaseController
{
    /* ================= LIST ROLES ================= */
    public function index()
    {
        $this->requireLogin();
        $this->requirePermission('admin_manage_roles');

        $roles = Database::fetchAll(
            "SELECT * FROM roles ORDER BY id ASC"
        );

        $this->render('admin/roles/index', compact('roles'));
    }

    /* ================= CREATE ROLE ================= */
    public function create()
    {
        $this->requireLogin();
        $this->requirePermission('admin_manage_roles');

        $permissions = Database::fetchAll(
            "SELECT * FROM permissions ORDER BY id ASC"
        );

        $this->render('admin/roles/create', compact('permissions'));
    }

    /* ================= STORE ROLE ================= */
    public function store()
    {
        $this->requireLogin();
        $this->requirePermission('admin_manage_roles');

        $name = trim($_POST['name'] ?? '');

        if (!$name) {
            header('Location: /admin/roles');
            exit;
        }

        Database::execute(
            "INSERT INTO roles (name) VALUES (?)",
            [$name]
        );

        header('Location: /admin/roles');
        exit;
    }

    /* ================= EDIT ROLE ================= */
    public function edit()
    {
        $this->requireLogin();
        $this->requirePermission('admin_manage_roles');

        $id = (int)($_GET['id'] ?? 0);

        $role = Database::fetchOne(
            "SELECT * FROM roles WHERE id = ?",
            [$id]
        );

        if (!$role) {
            http_response_code(404);
            require __DIR__ . '/../../../resources/views/errors/404.php';
            exit;
        }

        $permissions = Database::fetchAll(
            "SELECT * FROM permissions ORDER BY id ASC"
        );

        $assigned = Database::fetchAll(
            "SELECT permission_id FROM role_permissions WHERE role_id = ?",
            [$id]
        );

        $assignedIds = array_column($assigned, 'permission_id');

        $this->render('admin/roles/edit', compact(
            'role',
            'permissions',
            'assignedIds'
        ));
    }

    /* ================= UPDATE ROLE ================= */
    public function update()
    {
        $this->requireLogin();
        $this->requirePermission('admin_manage_roles');

        $id = (int)($_POST['id'] ?? 0);
        $name = trim($_POST['name'] ?? '');
        $permissionIds = $_POST['permissions'] ?? [];

        Database::begin();

        try {

            Database::execute(
                "UPDATE roles SET name = ? WHERE id = ?",
                [$name, $id]
            );

            Database::execute(
                "DELETE FROM role_permissions WHERE role_id = ?",
                [$id]
            );

            foreach ($permissionIds as $pid) {
                Database::execute(
                    "INSERT INTO role_permissions (role_id, permission_id)
                     VALUES (?, ?)",
                    [$id, $pid]
                );
            }

            Database::commit();

        } catch (\Throwable $e) {
            Database::rollback();
        }

        header('Location: /admin/roles');
        exit;
    }
}
